/*
 * Decompiled with CFR 0.152.
 */
package tiled.plugins.mappy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import tiled.core.Map;
import tiled.core.TileSet;
import tiled.io.MapWriter;
import tiled.io.PluginLogger;
import tiled.plugins.mappy.Chunk;
import tiled.plugins.mappy.MappyMapReader;
import tiled.plugins.mappy.Util;

public class MappyMapWriter
implements MapWriter {
    private final LinkedList chunks = new LinkedList();

    public void writeMap(Map map, String string) throws Exception {
        this.writeMap(map, new FileOutputStream(string));
    }

    public void writeTileset(TileSet tileSet, String string) throws Exception {
        System.out.println("Asked to write " + string);
    }

    public void writeMap(Map map, OutputStream outputStream) throws Exception {
        outputStream.write("FORM".getBytes());
        outputStream.write("FMAP".getBytes());
        this.createMPHDChunk(map);
    }

    public void writeTileset(TileSet tileSet, OutputStream outputStream) throws Exception {
        System.out.println("Tilesets are not supported!");
    }

    public String getFilter() throws Exception {
        return "*.map";
    }

    public String getDescription() {
        return "+---------------------------------------------+\n|    A sloppy writer for Mappy FMAP (v0.36)   |\n|             (c) Adam Turk 2004              |\n|          aturk@biggeruniverse.com           |\n+---------------------------------------------+";
    }

    public String getPluginPackage() {
        return "Mappy output plugin";
    }

    public String getName() {
        return "Mappy Writer";
    }

    public boolean accept(File file) {
        try {
            String string = file.getCanonicalPath().toLowerCase();
            if (string.endsWith(".fmp")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void setLogger(PluginLogger pluginLogger) {
    }

    private void createMPHDChunk(Map map) throws IOException {
        Chunk chunk = new Chunk("MPHD");
        OutputStream outputStream = chunk.getOutputStream();
        String string = map.getProperties().getProperty("version");
        if (string == null || string.length() < 3) {
            string = "0.3";
        }
        TileSet tileSet = (TileSet)map.getTilesets().get(0);
        outputStream.write(0);
        outputStream.write(3);
        outputStream.write(1);
        outputStream.write(0);
        Util.writeShort(map.getWidth(), outputStream);
        Util.writeShort(map.getHeight(), outputStream);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        Util.writeShort(map.getTileWidth(), outputStream);
        Util.writeShort(map.getTileHeight(), outputStream);
        Util.writeShort(16, outputStream);
        Util.writeShort(32, outputStream);
        Util.writeShort(this.findAllBlocks(map).size(), outputStream);
        Util.writeShort(tileSet.getMaxTileId(), outputStream);
        this.chunks.add(chunk);
    }

    private void createBKDTChunk(Map map) {
        Chunk chunk = new Chunk("BKDT");
        LinkedList linkedList = this.findAllBlocks(map);
        for (MappyMapReader.BlkStr blkStr : linkedList) {
        }
        this.chunks.add(chunk);
    }

    private LinkedList findAllBlocks(Map map) {
        return null;
    }
}

